( function( $ ) {// jscs:ignore validateLineBreaks
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-name a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

    // Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-name, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-name, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );

				$( '.site-name, .site-name a, .site-description, .site-description a' ).css( {
					color: to
				} );
			}
		} );
	} );
} )( jQuery );
