<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

	<div <?php if (function_exists('post_class')) post_class('post') ?>>
		<div class="post-header" id="post-<?php the_ID(); ?>">
			<h2 class="sub-header"><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			<h3><?php the_time(get_settings('date_format')) ?> // Posted in <?php the_category(', ') ?> &nbsp;<?php edit_post_link('Edit', '| (', ')'); ?></h3>
		</div>
		<div class="post-body">
			<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>
			<?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
		</div>
		<div class="post-description">
			<p>This entry was posted on <?php the_time(get_settings('date_format')) ?> at <?php the_time(get_settings('time_format')) ?> and is filed under <?php the_category(', ') ?><?php the_tags( ' (Tags: ', ', ', ')'); ?>.
			You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed.
			<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
				// Both Comments and Pings are open ?>
				You can <a href="#reply">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.
			<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
				// Only Pings are Open ?>
				Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.
			<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
				// Comments are open, Pings are not ?>
				You can skip to the end and leave a response. Pinging is currently not allowed.
			<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
				// Neither Comments, nor Pings are open ?>
				Both comments and pings are currently closed.
			<?php } edit_post_link('Edit this entry.','',''); ?></p>
		</div>
	</div>

	<?php comments_template(); ?>

<?php endwhile; else: ?>

	<p>Sorry, no posts matched your criteria.</p>

<?php endif; ?>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
