<?php // Do not delete these lines
	if ('legacy.comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	if (!empty($post->post_password)) { // if there's a password
		if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie
		?>

			<p class="nocomments">This post is password protected. Enter the password to view comments.<p>
		<?php
			return;
		}
	}

		/* This variable is for alternating comment background */
		$oddcomment = 'alt';
?>

<!-- You can start editing here. -->

<div id="comments-wrapper">

	<div id="comments">

		<?php if ($comments) : ?>

			<h3>Comments <span>(<?php comments_number('0', '1', '%' );?>)</span></h3>
			<ul class="comments-lists">

			<?php foreach ($comments as $comment) : ?>
				<li id="comment-<?php comment_ID() ?>">
					<div id="div-comment-<?php comment_ID() ?>">
						<div class="comment-author vcard">
							<?php echo get_avatar($comment,32) ?>
							<cite class="fn"><?php comment_author_link() ?><?php if ($comment->comment_approved == '0') : ?> <em>(Your comment is awaiting moderation)</em> <?php endif; ?><span class="says"> says</span><?php edit_comment_link(' (edit)','',''); ?>:</cite>
						</div>
						<div class="comment-meta commentmetadata">
							<a href="#comment-<?php comment_ID() ?>"><?php comment_date() ?> at <?php comment_time() ?></a>
						</div>
						<?php comment_text() ?>
					</div>
				</li>
			<?php endforeach; /* end for each comment */ ?>

			</ul>

		<?php else : // this is displayed if there are no comments so far ?>

			<?php if ('open' == $post->comment_status) : ?>
			<!-- If comments are open, but there are no comments. -->

			<?php else : // comments are closed ?>
			<!-- If comments are closed. -->
				<p class="nocomments">Comments are closed.</p>
			<?php endif; ?>

		<?php endif; ?>

	</div>

	<?php if ('open' == $post->comment_status) : ?>

		<div id="respond">
			<h3>Leave a reply <span>(name &amp; email required)</span></h3>

			<?php if ( get_option('comment_registration') && !$user_ID ) : ?>

				<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">logged in</a> to post a comment.</p>

			<?php else : ?>

				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
				<?php if ( $user_ID ) : ?>
					<p class="info">Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="Log out of this account">Logout &raquo;</a></p>
				<?php else : ?>
					<div class="row">
						<label for="name">Name:</label><div class="inputs-box"><input type="text" id="name" name="author" class="text" value="<?php echo $comment_author; ?>" tabindex="1" /></div>
					</div>
					<div class="row">
						<label for="mail">Mail:</label><div class="inputs-box"><input type="text" id="mail" name="email" class="text" value="<?php echo $comment_author_email; ?>" tabindex="2" /></div>
					</div>
					<div class="row">
						<label for="website">Website:</label><div class="inputs-box"><input type="text" id="website" name="url" class="text" value="<?php echo $comment_author_url; ?>" tabindex="3" /></div>
					</div>
				<?php endif; ?>
				<div class="row">
					<label for="comment">Comment:</label><div class="inputs-box"><textarea id="comment" name="comment" cols="30" rows="8" tabindex="4"></textarea></div>
				</div>
				<div class="box-submit">
					<input type="image" src="<?php bloginfo('template_url');?>/images/grid/button_send.gif" id="button_submit" name="button_submit" title="Leave a reply" tabindex="5" />
					<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
					<?php do_action('comment_form', $post->ID); ?>
				</div>
			</form>

			<?php endif; // If registration required and not logged in ?>

		</div>

	<?php endif; // if you delete this the sky will fall on your head ?>

</div>