<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php bloginfo('name'); ?> <?php if ( is_single() ) { ?> &raquo; Blog Archive <?php } ?> <?php wp_title(); ?></title>
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->
<link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/stylesheets/basic.css" type="text/css" media="screen" />
<!--[if lte IE 6]>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/stylesheets/uptoie6.css" media="screen,projection" />
<![endif]-->
<!--[if gt IE 6]>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/stylesheets/gtie6.css" media="screen,projection" />
<![endif]-->
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/scripts/jquery.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/scripts/visuals.js"></script>
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<?php wp_head(); ?>
</head>
<body>
<div id="root">
	<div id="wrapper-header">
		<div id="header">
				<h1><a href="<?php echo get_settings('home'); ?>/" title="Go home page"><?php bloginfo('name'); ?></a></h1>
				<h2 id="description"><?php bloginfo('description'); ?></h2>
		</div>
	</div>
	<div id="wrapper-1">
		<div id="wrapper">
			<div id="wrapper-content-1">
				<div id="wrapper-content-2">
					<div id="content">
						<?php /* If this is a 404 page */ if (is_404()) { ?>
							<div class="archives-info">
								<h3><strong>Ooops!</strong> You got lost!</h3>
							</div>
						<?php /* If this is a category archive */ } elseif (is_category()) { ?>
							<div class="archives-info">
								<h3>You are currently browsing the archives for the <strong>&ldquo;<?php single_cat_title(''); ?>&rdquo; category.</strong></h3>
							</div>
						<?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
							<div class="archives-info">
								<h3>You are currently browsing posts tagged <strong>&ldquo;<?php single_tag_title(); ?>&rdquo;</strong></h3>
							</div>
						<?php /* If this is daily archive */ } elseif (is_day()) { ?>
							<div class="archives-info">
								<h3>You are currently browsing the archives for the day <strong><?php the_time('l, F jS, Y'); ?></strong>.</h3>
							</div>
						<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
							<div class="archives-info">
								<h3>You are currently browsing the archives for <strong><?php the_time('F, Y'); ?></strong>.</h3>
							</div>
						<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
							<div class="archives-info">
								<h3>You are currently browsing the archives for the year <strong><?php the_time('Y'); ?></strong>.</h3>
							</div>
						<?php /* If this is search page */ } elseif (is_search()) { ?>
							<div class="archives-info">
								<h3>You have searched the archives for <strong>'<?php echo wp_specialchars($s); ?>'</strong>.</h3>
							</div>
						<?php /* If this is  archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
							<div class="archives-info">
								<h3>You are currently browsing the archives.</h3>
							</div>
						<?php } ?>
