<?php

// WP2.7 new comments
	
add_filter( 'comments_template', 'legacy_comments' );
function legacy_comments( $file ) {
	if ( !function_exists('wp_list_comments') )
		$file = TEMPLATEPATH . '/legacy.comments.php';
	return $file;
}

// TinyMCE part

function my_change_mce_settings( $init_array ) {
	$init_array['theme_advanced_blockformats'] = 'p,pre,h3,h4,h5,h6';
	return $init_array;
}
add_filter( 'tiny_mce_before_init', 'my_change_mce_settings' );
 
function my_plugin_css($css) {
	return $css . "," . get_bloginfo('template_url') . "/stylesheets/post.css";
}
add_filter("mce_css", "my_plugin_css");

// Widgets part

function widget_mytheme_search() {
	echo '<li id="widget_search" class="widget widget_search search-box">';
	echo '<form method="get" id="searchform" action="'.get_bloginfo('home').'/">';
	echo '<div>';
	echo '<div class="inputs-box"><input type="text" id="search" name="s" value="'.wp_specialchars($s,1).'" /></div>';
	echo '<input type="image" src="'.get_bloginfo('template_directory').'/images/grid/button_search.gif" id="btn_search" name="btn_search" title="Search" />';
	echo '</div>';
	echo '</form>';
	echo '</li>';
}

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Search'), 'widget_mytheme_search');

if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'before_widget' => '<li id="widget_%1$s" class="widget %2$s">',
		'after_widget' => '</div></li>',
		'before_title' => '<h2 class="widgettitle"><span>',
		'after_title' => '</span></h2><div>',
	)
);

?>