<?php // Do not delete these lines
	
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) die ('Please do not load this page directly. Thanks!');
	if ( post_password_required() ) { 
?>
		<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
<?php
		return;
	}
?>

<!-- You can start editing here. -->

<div id="comments-wrapper">

	<div id="comments">

		<?php if ( have_comments() ) : ?>

			<h3>Comments <span>(<?php comments_number('0', '1', '%' );?>)</span></h3>
			<ul class="comments-lists">

				<?php wp_list_comments(); ?>

			</ul>
			<div class="nav-prev-next-comment">
				<div class="prev"><?php next_comments_link() ?></div>
				<div class="next"><?php previous_comments_link() ?></div>
			</div>

		<?php else : // this is displayed if there are no comments so far ?>

			<?php if ('open' == $post->comment_status) : ?>
			<!-- If comments are open, but there are no comments. -->

			<?php else : // comments are closed ?>
			<!-- If comments are closed. -->
				<p class="nocomments">Comments are closed.</p>
			<?php endif; ?>

		<?php endif; ?>

	</div>

	<?php if ('open' == $post->comment_status) : ?>

		<div id="respond">
		
			<h3><?php comment_form_title( 'Leave a Reply', 'Leave a Reply to %s' ); ?> <span>(name &amp; email required)</span></h3>

			<?php if ( get_option('comment_registration') && !$user_ID ) : ?>

				<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">logged in</a> to post a comment.</p>

			<?php else : ?>

				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
				<?php if ( $user_ID ) : ?>
					<p class="info">Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Logout &raquo;</a></p>
				<?php else : ?>
					<div class="row">
						<label for="name">Name:</label><div class="inputs-box"><input type="text" id="name" name="author" class="text" value="<?php echo $comment_author; ?>" tabindex="1" /></div>
					</div>
					<div class="row">
						<label for="mail">Mail:</label><div class="inputs-box"><input type="text" id="mail" name="email" class="text" value="<?php echo $comment_author_email; ?>" tabindex="2" /></div>
					</div>
					<div class="row">
						<label for="website">Website:</label><div class="inputs-box"><input type="text" id="website" name="url" class="text" value="<?php echo $comment_author_url; ?>" tabindex="3" /></div>
					</div>
				<?php endif; ?>
				<div class="row">
					<label for="comment">Comment:</label><div class="inputs-box"><textarea id="comment" name="comment" cols="30" rows="8" tabindex="4"></textarea></div>
				</div>
				<div class="box-submit">
					<div id="cancel-comment-reply">
						<?php cancel_comment_reply_link() ?>
					</div>
					<input type="image" src="<?php bloginfo('template_url');?>/images/grid/button_send.gif" id="button_submit" name="button_submit" title="Leave a reply" tabindex="5" />
					<?php comment_id_fields(); ?>
					<?php do_action('comment_form', $post->ID); ?>
				</div>
			</form>

			<?php endif; // If registration required and not logged in ?>

		</div>

	<?php endif; // if you delete this the sky will fall on your head ?>

</div> 