/*   
Theme Name: Osmium Foliage
Theme URI: http://aslamp.com/projects
Description: A modded version of Derek Punsalan's <a href="http://5thirtyone.com">Foliage</a>, inspired by Blackheart6004's <a href="http://www.deviantart.com/deviation/25296467/">Osmium</a>.
Author: Lamp
Author URI: http://aslamp.com
Template: osmium
Version: 1.0
*/

/* =general & repeats
================================================= */

body { behavior:url("http://www.xs4all.nl/~peterned/htc/csshover.htc"); }

* { /* removes global padding & margins */
  margin: 0;
  padding: 0;
}

h1, h2, h3, p, pre, blockquote, form, fieldset, ul {
  margin: 1em 0; /* give me back my basic margins */
}

h1, h2, h3 {
  font-family: Arial, Helvetica, sans-serif;
  text-transform: lowercase;
  letter-spacing: -1px;
  color: #f0f0f0;
}

h1 {font-size: 2em;}
h2 {font-size: 1.9em;}
h3 {font-size: 1.6em; line-height:1.7em;}

.entry strong, #bottom strong {
  color: #fff;
}

a {text-decoration: none;}
a:active {outline: none;}

a:link, a:active, a:visited {color: #f0f0f0;}

  a:hover {color: #fff;}

p, li {
  font-size: 1.2em;
  line-height: 1.4em;
  font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
  color: #cde;
}

body {
  font-size: 62.5%; /* resets to 10px */
  margin: -1.2em 0;
  background: #456;
  max-width: 100%;
}

em, i {
  font-style:italic!important;
}

/* =navigation
================================================= */

#header {
  display: block;
  width:100%;
  background: #48596a;
  border-bottom: 2px solid #567;
  text-align: center;
  margin:0px;
  padding:0px;
}

#header {
  text-align: -moz-center;
}

#navigation {
  width: 44em;
  text-align: center;
  font-weight: bold;
  font-family: Arial, Helvetica, sans-serif;
  font-size: 1.2em;
  text-transform: lowercase;
  letter-spacing: -1px;
  padding:0px;
  margin:0px;
}

  #navigation li.navig {
    float:right;
    width: 7.5em;
    list-style: none;
    margin-top:30px;
  }
  
  #navigation li.left {
    float: left;
  }

  #navigation li.navig a {
    display: block;
    width: 7.5em;
    line-height: 3.1em;
    color: #f0f0f0;
    background: #48596a;
    border: 1px solid #48596a;
    overflow:visible;
    border-bottom: 2px solid #567;
  }
  
  #navigation li.navig a:hover {
    color: #f0f0f0;
    background: #456;
    border: 1px solid #567;
    border-bottom: 2px solid #456;
  }

h1 {
  padding:15px 0 15px 0;
  margin:0px;
  width:530px;
  font-size: 30px;
  height:30px;
  font-family: Arial, Helvetica, sans-serif;
  text-transform: lowercase;
  letter-spacing: -1px;
  color: #567!important;
  text-align:left;
}

h1 .left {
  float:left;
}

.left .navg {
  display:none;
}

.left:hover .navg {
  display:inline;
}

.navg a {
  font-size:22px;
  color:#567!important;
}

.navg a:hover {
  color:#f0f0f0!important;
}

h1 span {
  color: #567;
}

h1 .right {
  float:right;
}

/* =top page
================================================= */

#page {
  width: 550px;
  margin: 0 auto;
  text-align: left;
}

.content {
  margin-top: 0em;
  padding: 0 2% 1%;
}

.chrondate {
  color:#567!important;
  display:inline;
}
.chrondate a{
  color:#567!important;
}
.chrondate a:hover {
  color:#cde!important;
}

.post {
  position: relative;
  padding-bottom: 0em;
}
  /* hides from ie-mac \*/
  * html .post { /* fixes ie for absolutely pos. comments button */
    height: 1%;
  }
  
.entrycomments {
  position: absolute;
  right: 0;
  bottom: 0;
  font-size: 0.9em;
  letter-spacing: -1px;
}

  .entrycomments a {
    text-align: center;
    display: block;
    padding: 0.3em;
    padding-bottom: 0em;
    line-height: 1.2em;
    outline: none;
  }
  
  .entrycomments a:link, .entrycomments a:visited {
    color: #cde;
  }
  
  .entrycomments a:hover, .entrycomments a:active {
    color: #f0f0f0;
  }

.entry {
  padding-bottom: .0em;
}

  .entry a:link, .entry a:active, .entry a:visited {
    color: #f0f0f0;
  }
  
  .entry a:hover {
    color: #ffffff;
  }
  
  .entry h3 {
    padding-left: 1.6em;
    margin-top: 1.5em;  
  }
  
  .entry ul {
    list-style: square inside;
  }
    
  .entry li {
    width: 34.5em;
  }
    
  .entry ul li {
    padding-left: 1.3em;
    margin-left: 3em;
    background-position: 0 0.4em;
  }

  .entry ol {
    margin: 0 0 0 5.5em;  
  }
  
  .entry blockquote p {
    margin-left: 3em;
    width: 34em;
    color: #9f9f9f;
  }
  
.entrymeta {
  font-size: 0.9em;
  margin: -2.2em 0 1.6em 0;
  text-transform: lowercase;
}
  
/* =comments
================================================= */
.tabbedCommentslive .commentTabhide {display:none;}

.tabbedCommentslive {
  margin-top: 3em;
  margin-bottom: 2em;
}

ul.tabbedCommentsnav {
  margin:0;
  padding:0;
  text-transform: lowercase;
  font-weight: bold;
  font-size: 1.2em;
  letter-spacing: -1px;
}

  .tabbedCommentsnav li {
    list-style: none;
    margin: 0;
    display: inline;
  }

  .tabbedCommentsnav li a {
    padding: 0.3em 0.5em;
    background: #567;
    border-top: 1px solid #567;
    border-right: 1px solid #567;
    border-left: 1px solid #567;
    border-bottom: 1px solid #48596a;
    margin-right: 0.1em;
  }
  
    .tabbedCommentsnav li.tabbedCommentsactive a {
      background-color: #48596a; /* active tab */
    }

    .tabbedCommentsnav li a:hover, 
    .tabbedCommentsnav li.tabbedCommentsactive a:hover {
      color: #f0f0f0;
      background: #48596a;
    }

.tabbedCommentslive .commentTab {
  background: #48596a;
  padding: 1.2em 0.5em;
  margin: 0.2em 0 0 0;
  border: 1px solid #567;
}

.commentlist li {
  list-style: none;
  font-size: 1em;
  margin-bottom: 0.5em;
  background: #456;
  border-top: 1px solid #567;
  border-bottom: 1px solid #567;
  width: 50.8em;
}

  .comment {
    overflow: auto;
    padding: 0 0.5em 0.6em 0.5em;
    outline: none;
  }
  
  li.alt {
    background: #3f3f3f;
    border-top: 1px solid #444;
    border-bottom: 1px solid #444;
  }
  
  li.author {
    background: #567;
    border-top: 1px solid #567;
    border-bottom: 1px solid #567;
  }
  
  .commentmeta {
    text-align: left;
    color: #f0f0f0;
  }
  
    .commentmeta a:link, .commentmeta a:active, .commentmeta a:visited {color: #f0f0f0;}
      .author a:link, .author a:active, .author a:visited {color: #cde;}
    .commentmeta a:hover, li.author a:hover, li.specialguest a:hover {color: #fff;}
    

/* =bottom page
================================================= */

#bottom {
  width: 100%;
  background: #48596a; 
  border-top:2px #567 solid;
}

#bottomwrap {
  margin: 0 auto;
  padding-top: 3%;
  padding-left: 1.5%;
  width: 550px;
}

#bottomwrap a:hover {color: #fff;}

  #bottomwrap ul {
    margin-left: 1.9em;
  }
  
  #bottomwrap ul li {
    padding-left: 0em;
    background-position: 0 0.4em;

  }
  
  #bottomnav li {
    list-style:square inside;
  }
  
.toolshed {
  padding-left: 1.6em;
  padding-left: 0em;
  margin-top: 1.5em;  
}
  
#bottomleft {
  float: left;
  width: 25em;
  position: relative;
}

#bottomnav li a span {
  display: none;
}
    
  #bottomnav li a:hover span {
    display: inline;
  }
  
#bottomright {
  float: right;
  width: 25em;
  overflow: hidden;
}

/* favicon links inspired by kristin
  http://www.wiphey.com/2006/02/07/wp-quicky-1-9rules-style-links-page/ */
  
#linkage {
  list-style:none!important;
}

#linkage li {
  background-image: none !important; /* overrides li background images */
  margin-left: -1.3em;
  list-style:none;
}

#linkage ul {
  margin: 0;
  padding: 0;
  list-style:none;
}

#linkage ul li {
  margin: 0;
  padding: 0 0 0.2em 0;
  display: block;
  width: 25em;
  display: inline;
  list-style:none;
  }

#linkage h2 {
  font-size: 1.2em;
  margin: 0 0 0.2em 0;
  padding: 0 0 0.2em 0;
    text-transform: lowercase;
}

#linkage img {
  padding: 2px;
  background: #456;
  border: 1px solid #567;
   width: 16px;
   height: 16px;
}

li.linkcat ul {
  margin: 0;
  padding: 0;
  list-style-type:none;
}

li.linkcat ul li {
  margin: 0;
  padding: 0 0 0.2em 0;
  display: block;
  width: 25em;
  display: inline;
  list-style:none;
  }

li.linkcat .widgettitle {
  font-size: 1.2em;
  margin: 0 0 0.2em 0;
  padding: 0 0 0.2em 0;
    text-transform: lowercase;
    list-style:none;
}

li.linkcat img {
  padding: 2px;
  background: #456;
  border: 1px solid #567;
   width: 16px;
   height: 16px;
}

.linkageNotes a:active, .linkageNotes a:link, .linkageNotes a:visited {
  color: #f0f0f0;
}

/* =footer
================================================= */

#footer {
  text-align: center;
  padding: 0.5em 0 0.3em;
  text-transform: lowercase;
}

#footer a:hover {color: #fff;}

/* =misc & images
================================================= */

img {background: #48596a; border: 1px solid #567; padding: 2px; clear: both;}

.flickr_badge_image { background: #48596a!important; border: 1px solid #567!important; padding: 2px!important; }

.flickr_badge_image a img { border:0px!important; padding:0px!important; }

#flickr_badge_image3 { clear:both!important; }

#flickr_badge_uber_wrapper { width:200px!important;}

.gravatar {
  float: right;
  border: 1px #567 solid;
  padding: 2px;
  margin: 0.5em 0 0 0.5em;
}

abbr[title] {border-bottom: 1px dotted #999;}
abbr[title]:hover {cursor: help;}
  
.clear { /* for clearing floats */
  clear: both;
}

.alignleft {float: left;}
.alignright {float: right;}

#tagcloud {
  font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
  font-size: 1.2em;
  margin-bottom: 2.8em;
}

.wp-smiley {
  border: 0;
}

/* =forms
================================================= */

#s {
  width: 15em;
  background: #333;
  border: 1px solid #567;
  color: #f0f0f0;
  padding: 0.3em;
}

#submit, #searchsubmit, #author, #url, #email, #comment {
  border: 1px solid #567;
  background: #333;
  padding: 0.3em;
  color: #f0f0f0;
  font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
  font-size: 0.9em;
}

#author, #url, #email, #comment {
  color: #f0f0f0;
  border: 1px solid #4f4f4f;
}

.commentTab #submit {
  background: #456;
  border: 1px solid #567;
  color: #f0f0f0;
  padding: 0.3em 0.3em;
  font-size: 0.9em;
}

  #author, #email, #url {
    width: 15em;
  }
  
  #comment {
    width: 46.2em;
    height: 15em;
    overflow: auto;
  }

p.musicplayer {
  clear:both;
  padding:3px;
  background-color:#456;
  border:#567 solid 1px;
}

/* =sidebar
================================================= */

.leftcontent {
  float: left;
  width:50%;
}

.rightcontent {
  float:right;
  width:50%;
}

#sidebar h3.widgettitle {font-size: 1.6em; line-height:1.7em; padding:0px margin:0px;}

.textwidget { 
  font-size: 1.2em;
  line-height: 1.24em;
  font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
  color: #cde;
  list-style:none; 
}

.textwidget div {
  margin:0px 3px 3px 0px;
  padding:0px;
  float:left;
}

.widget ul {
  padding:0px;
  margin:0px;
  list-style:square inside;
}

.widget li {
  padding-left:10px;
  list-style:square inside;
}